// import multer from 'multer';
// import expFil from 'express-fileupload'

// const storage = multer.memoryStorage()
// export const multerUpload = multer({ 
//     storage: storage,
//     // limits: {
//     //     fileSize: 10 * 1024 * 1024, // Limit file size to 10MB
//     //     fieldSize: 2 * 1024 * 1024  // Limit non-file field size to 2MB
//     // }
// });

// // export const expressUpload = 

///////////////////////////////////////////////////////////////////

import multer from 'multer';
import { NextFunction, Request, Response } from 'express';
import path from 'path';
import fs from 'fs';
import { v4 as uuidv4 } from 'uuid';
import fsPromises from 'fs/promises';

// // Define allowed file types
// const allowedFileTypes = ['application/pdf', 'image/jpeg', 'image/png'];

// // const storage = multer.memoryStorage();
// const storage = multer.diskStorage({
//   destination: (req, file, cb) => {
//     // Generate a temporary directory based on a unique identifier
//     const tempFolder = uuidv4();
//     const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', 'temp', tempFolder);

//     // Ensure that the directory exists
//     fs.mkdirSync(uploadDir, { recursive: true }); // Recursively create the directory if it doesn't exist

//     // Attach the temporary folder path to the request for further use
//     req.body.tempUploadDir = uploadDir;

//     cb(null, uploadDir); // Pass the directory to multer
//   },
//   filename: (req, file, cb) => {
//     const uniqueName = `${Date.now()}-${file.fieldname}`;
//     cb(null, uniqueName); // You can use any naming strategy here
//   }
// });

// // Define the fileFilter function to check file type
// const fileFilter = (req: any, file: any, cb: any) => {
//   if (allowedFileTypes.includes(file.mimetype)) {
//     cb(null, true);
//   } else {
//     cb(new Error('Invalid file type. Only PDF, JPEG, and PNG are allowed.'), false);
//   }
// };

// export const multerUpload = multer({
//   storage: storage,
//   limits: {
//     fileSize: 500 * 1024 // Limit file size to 500KB
//   },
//   fileFilter: fileFilter
// });

// // Custom error handling middleware for file size
// export const fileUploadErrorHandler = (err: any, req: Request, res: Response, next: NextFunction) => {
//   // Log the error for debugging
//   console.error(err, 'INSIDE multer file');

//   // Handle Multer's specific errors
//   if (err instanceof multer.MulterError) {
//     switch (err.code) {
//       case 'LIMIT_FILE_SIZE':
//         console.log('herf')
//         return res.status(400).json({ error: `File size exceeds the 500KB limit at ${err.field}`, message: `File size exceeds the 500KB limit at ${err.field}` });
//       default:
//         return res.status(400).json({ error: `Multer error: ${err.message}`, message: err.message });
//     }
//   }

//   // Handle other types of errors (e.g., invalid file type)
//   if (err.message) {
//     return res.status(400).json({ error: err.message, message: err.message });
//   }

//   // If the error is unhandled, pass it to the next error handler
//   next(err);
// };


// export const moveFilesToUserFolder = (userId: number, tempDir: string) => {
//   const userDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', userId.toString());

//   // Create the user directory if it doesn't exist
//   if (!fs.existsSync(userDir)) {
//     fs.mkdirSync(userDir, { recursive: true });
//   }

//   // Move files from temporary to user directory
//   fs.readdirSync(tempDir).forEach(file => {
//     fs.renameSync(path.join(tempDir, file), path.join(userDir, file));
//   });

//   // Delete the temporary directory
//   console.log('DELETING TEMP after being successful')
//   fs.rmdirSync(tempDir, { recursive: true });
// };

// export const cleanupTempFiles = (tempDir: string) => {
//   console.log('DELETING TEMP')
//   if (fs.existsSync(tempDir)) {
//     // Delete each file in the directory
//     fs.readdirSync(tempDir).forEach(file => {
//       fs.unlinkSync(path.join(tempDir, file));
//     });
//     // Delete the temporary folder
//     fs.rmdirSync(tempDir, { recursive: true });
//   }
// };



const allowedFileTypes = ['application/pdf', 'image/jpeg', 'image/png'];

const directoryExists = async (dir: string) => {
  try {
    await fsPromises.access(dir);
    return true;
  } catch {
    return false;
  }
};

// const storage = multer.diskStorage({
//   destination: async (req, file, cb) => {
//     const tempFolder = uuidv4();
//     const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', 'temp', tempFolder);

//     // Create the temp directory
//     await fsPromises.mkdir(uploadDir, { recursive: true });

//     // Attach the directory to req for later use
//     req.body.tempUploadDir = uploadDir;

//     cb(null, uploadDir);
//   },
//   filename: (req, file, cb) => {
//     const uniqueName = `${Date.now()}-${file.fieldname}`;
//     cb(null, uniqueName);
//   }
// });
const storage = multer.diskStorage({
  destination: async (req, file, cb) => {

    if (req.body.uploadDir) {
      cb(null, req.body.uploadDir);
    } else {
      const tempFolder = uuidv4();
      const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', 'temp', tempFolder);

      // Create the temp directory
      await fsPromises.mkdir(uploadDir, { recursive: true });

      // Attach the directory to req for later use
      req.body.tempUploadDir = uploadDir;

      cb(null, uploadDir);
    }
  },
  filename: (req, file, cb) => {
    const uniqueName = `${Date.now()}-${file.fieldname}`;
    cb(null, uniqueName);
  }
});

const fileFilter = (req: any, file: any, cb: any) => {
  if (allowedFileTypes.includes(file.mimetype)) {
    cb(null, true);
  } else {
    cb(new Error('Invalid file type. Only PDF, JPEG, and PNG are allowed.'), false);
  }
};

export const multerUpload = multer({
  storage: storage,
  limits: {
    fileSize: 500 * 1024 // Limit file size to 500KB
  },
  fileFilter: fileFilter
});

export const fileUploadErrorHandler = (err: any, req: Request, res: Response, next: NextFunction) => {
  // Log the error for debugging
  console.error(err, 'INSIDE multer file');

  // Handle Multer's specific errors
  if (err instanceof multer.MulterError) {
    switch (err.code) {
      case 'LIMIT_FILE_SIZE':
        console.log('herf')
        return res.status(400).json({ error: `File size exceeds the 500KB limit at ${err.field}`, message: `File size exceeds the 500KB limit at ${err.field}` });
      default:
        return res.status(400).json({ error: `Multer error: ${err.message}`, message: err.message });
    }
  }

  // Handle other types of errors (e.g., invalid file type)
  if (err.message) {
    return res.status(400).json({ error: err.message, message: err.message });
  }

  // If the error is unhandled, pass it to the next error handler
  next(err);
};

// Function to move files to a user-specific folder
// export const moveFilesToUserFolder = async (userId: number, tempDir: string) => {
//   const userDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', userId.toString());

//   // Create the user directory if it doesn't exist
//   await fsPromises.mkdir(userDir, { recursive: true });

//   const files = await fsPromises.readdir(tempDir);

//   await Promise.all(
//     files.map(file => fsPromises.rename(path.join(tempDir, file), path.join(userDir, file)))
//   );

//   // Clean up the temporary directory after files are moved
//   await cleanupTempFiles(tempDir);
// };

// Function to move files out of the temp folder
export const moveFilesOutOfTempFolder = async (tempDir: string) => {
  // Determine the new location for the files by removing the `temp` segment from the path
  const targetDir = tempDir.replace(/\/temp\//, '/');

  // Create the target directory if it doesn't exist
  await fsPromises.mkdir(targetDir, { recursive: true });

  // Read files in the temporary directory
  const files = await fsPromises.readdir(tempDir);

  // Move each file from tempDir to targetDir
  await Promise.all(
    files.map(file =>
      fsPromises.rename(path.join(tempDir, file), path.join(targetDir, file))
    )
  );

  // Clean up the temporary directory after files are moved
  await cleanupTempFiles(tempDir);
};

// Function to delete temporary files
export const cleanupTempFiles = async (tempDir: string) => {
  if (await directoryExists(tempDir)) {
    const files = await fsPromises.readdir(tempDir);

    await Promise.all(
      files.map(file => fsPromises.unlink(path.join(tempDir, file)))
    );

    await fsPromises.rmdir(tempDir); // Remove the empty folder
  }
};